<form action="{{ route('admin.premium-package.update', $data->id) }}" method="POST" novalidate="novalidate" enctype="multipart/form-data">
    @csrf
    <div class="row">
        <div class="form-group col-md-8">
            <label for="name">Name</label>
            <input type="text" class="form-control" id="name" name="name" value="{{$data->name}}" placeholder="Enter name">
        </div>

        <div class="form-group col-md-2">
            <label for="duration">Duration (Days)</label>
            <input type="number" class="form-control" id="duration" name="duration" value="{{$data->duration}}">
        </div>
 
        <div class="form-group col-md-2">
            <label for="cost">Cost</label>
            <input type="number" class="form-control" step="0.001" id="cost" name="cost" value="{{$data->cost}}">
        </div>
        
        @php
            $features = explode("|",$data->features);
        @endphp
        <input type="hidden" class="form-control" id="update_feature_serial_{{$data->id}}" value="{{count($features)}}">
        <div class="form-group col-12">
            <label for="features">Feature</label>
            <div id="update_package_feature_area_{{$data->id}}">
                @foreach($features as $f_key=>$feature)
                    <div class="input-group mb-2" id="update_feature_{{$data->id}}_{{$f_key+1}}">
                        <input type="text" class="form-control" name="features[]" value="{{$feature}}">
                        <button type="button" class="btn btn-sm btn-danger" onclick="deleteUpdateFeature('{{$data->id}}', '{{$f_key+1}}')">Delete</button>
                    </div>
                @endforeach
            </div>
            <div class="mt-1"><button type="button" class="btn btn-sm btn-info" onclick="addUpdateFeature('{{$data->id}}')">New</button></div>
        </div>
        
        <div class="form-group col-12 text-center">
            <button type="submit" class="btn btn-success"> <i class="fas fa-save"></i> Submit</button>
        </div>
    </div>
</form>